/*
	File:		TextPane.h

	Contains:	Class to drive text pane in MegaDialog.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#pragma once

#include "MegaPane.h"
#include <Appearance.h>

class TextPane : public MegaPane
{
	public:
			TextPane( DialogPtr dialog, SInt16 items );
		virtual ~TextPane();
		
		virtual void		Idle();
		virtual void		ItemHit( SInt16 item );
	
	private:
		static pascal ControlKeyFilterResult
			NumericFilter( ControlHandle control, SInt16* keyCode, SInt16* charCode,
							SInt16* modifiers);
		
		static ControlKeyFilterUPP		fFilterProc;

};
